#include "I2C.h"
#include <avr/io.h>

char status;

void i2c_initialize(){
  TWCR = 0b00000000;
  //100 kHZ: Table 1-1 in application note AVR315
  TWBR = 72;
  TWSR = 0;
}

void i2c_sendStartFrame(){
  TWCR = (1<<TWINT)|(1<<TWSTA)|(1<<TWEN);
  while (!(TWCR & (1<<TWINT))); //wait until start condition has been transmitted 
  if ((TWSR & 0xF8) != 0x08){
    //error
  } 
}

void i2c_sendStartFrameRepeat(){
  TWCR = (1<<TWINT)|(1<<TWSTA)|(1<<TWEN);
  while (!(TWCR & (1<<TWINT))); //wait until start condition has been transmitted 
  if ((TWSR & 0xF8) != 0x10){
    //error
  } 
}

void i2c_selectSlaveWrite(char device_addr){
  TWDR = device_addr & 0xfe;          // Load device address and R/W = 0 0xfe = 0b1111 1110 
  TWCR = (1 << TWINT) | (1 << TWEN);  // Start transmission
  while (!(TWCR & (1 << TWINT)));     // Wait for TWINT to be set
  status = TWSR & 0xf8;
  if (status != 0x18) {               // Check that SLA+W was sent OK
  }
}

void i2c_selectSlaveRead(char device_addr){
  TWDR = device_addr | 0x01;          // Load device address and R/W = 1 0x01 = 0b0000 0001
  TWCR = (1 << TWINT) | (1 << TWEN);  // Start transmission
  while (!(TWCR & (1 << TWINT)));     // Wait for TWINT to be set
  status = TWSR & 0xf8;
  if (status != 0x40) {               // Check that SLA+R was sent OK
  }
}

void i2c_writeByte(char data){
  TWDR = data;                      // Load DATA into TWDR Register
  TWCR = (1<<TWINT) | (1<<TWEN);    // Clear TWINNT bit to start transmission
  while (!(TWCR & (1<<TWINT)));     // Wait until the data has been send
  status = TWSR & 0xf8;
  if (status != 0x28) {           // Check that data was sent OK
  }
}

void i2c_readByte(int dataLength, char* dest){
  //read all bytes but the last and send ack
  for (int i = 0; i < dataLength-1; i++){
    TWCR = (1 << TWINT) | (1 << TWEN) | (1 << TWEA); // Read byte and send ACK                     
    while (!(TWCR & (1<<TWINT)));     // Wait until the data has been send
    status = TWSR & 0xf8;
    if (status != 0x50) {             // Check that data was sent OK
    }
    dest[i] = TWDR;                   // Read the data
  }

  //read last byte with not ack
  TWCR = (1 << TWINT) | (1 << TWEN);  // Read last byte with NOT ACK sent
  while (!(TWCR & (1 << TWINT)));     // Wait for TWINT to be set
  status = TWSR & 0xf8;
  if (status != 0x58){                // Check that data received OK
  }
  dest[dataLength-1] = TWDR;        // Read the data
}

void i2c_sendStopFrame(){
  TWCR = (1<<TWINT)|(1<<TWEN) | (1<<TWSTO); 
  while ((PINC & 0B00100000)==0);    //Wait until SCL line is high again (SCL = PINC5)
}
